﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;

namespace Mdws2ORM.Maps.WF
{
    public class PatientMovementIenMap : EntityMap<PatientMovementIen>
    {
        public override PatientMovementIen NewEntity(string ien)
        {
            return new PatientMovementIen() { IEN = ien };
        }

        public override string File
        {
            get { return "405"; }
        }

        public override string Location
        {
            get { return "DGPM("; }
        }

        protected override void MapFields()
        {
            MapDateTime(".01", (m, s) => m.MovementDate = s);
            MapDateTime("101", (m, s) => m.EnteredDate = s);
            MapPointerToFile(".02", (m, s) => m.TransactionTypeId = s);
            MapPointerToFile(".03", (m, s) => m.PatientIen = s);
            MapPointerToFile(".04", (m, s) => m.TypeOfMovementIen = s);
            MapPointerToFile(".06", (m, s) => m.WardLocationId = s);
            MapPointerToFile(".07", (m, s) => m.RoomBedId = s);
            MapPointerToFile(".14", (m, s) => m.CurrentAdmissionIen = s);            
        }
    }
}
